<?php

namespace App\DataFixtures;

use App\Factory\AnswerFactory;
use App\Factory\QuestionFactory;
use App\Factory\QuestionTagFactory;
use App\Factory\TagFactory;
use App\Factory\UserFactory;
use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Persistence\ObjectManager;

class AppFixtures extends Fixture
{
    public function load(ObjectManager $manager)
    {
        UserFactory::createOne([
            'email' => 'abraca_admin@example.com',
            'roles' => ['ROLE_ADMIN'],
        ]);
        UserFactory::createOne([
            'email' => 'abraca_user@example.com',
        ]);
        UserFactory::createMany(10);

        TagFactory::createMany(100);

        $questions = QuestionFactory::createMany(20, fn () => [
            'owner' => UserFactory::random(),
        ]);

        QuestionTagFactory::createMany(100, fn () => [
            'tag' => TagFactory::random(),
            'question' => QuestionFactory::random(),
        ]);

        QuestionFactory::new()
            ->unpublished()
            ->many(5)
            ->create()
        ;

        AnswerFactory::createMany(100, fn () => [
            'question' => $questions[array_rand($questions)],
        ]);
        AnswerFactory::new(fn () => [
            'question' => $questions[array_rand($questions)],
        ])->needsApproval()->many(20)->create();

        $manager->flush();
    }
}
